<?php
include_once 'ChillnetHostingSmsServiceProvider.php';

/**
 * ChillNet Bulk SMS Gateway Example
 *
 * @author Conrad van Straaten <conrad@chillnet.co.za>
 */
$sms = new ChillnetHostingSmsServiceProvider;

//Check how many credits are available on your account
$credits = $sms->getCredits();
echo "\n".number_format($credits).' Credits available.';

/**
 * Send a SMS message through the ChillNet Bulk SMS gateway
 * Please Note:
 *  - The 3rd optional parameter would be populated with a unique reference string
 *  - You would be able to use this reference at a later stage to query the delivery status of a given SMS message
 */
$mobileNumber = '27727284659';
$message = 'This is the body section of my SMS not exceeding 160 chars';
$gatewayReference = null;

$smsResult = $sms->sendMessage($mobileNumber,$message,$gatewayReference);
if($smsResult === true){
    echo "\n\nSMS Message successfully sent to {$mobileNumber}, reference #: ".$gatewayReference;
}else{
    echo "\n\nError sending SMS Message to {$mobileNumber} reference #: ".$smsResult;
}

//Get the Delivery Status of a given message sent earlier
$status = $sms->getDeliveryStatus($gatewayReference);
echo "\n\nDelivery Status of message id: {$gatewayReference} = {$status}\n\n";

?>